<?php
/*
Plugin Name: ゆずまるのフッタータグインサート footertag_insert
Description: /body 直前にタグを埋め込む
Version: 8.1102
Author: yuzumaru
*/
/********************************************************/
function footertag_insert_yuzu_ver()
/********************************************************/
{
	// ------------------------
	// [ version 表記 ]
	// ------------------------
	return "8.1102";
}
/********************************************************/
function footertag_insert_yuzu_tracesub($buf,$sw)
/********************************************************/
{
	// フォルダー名
	$myfolder ="brBrbr600yuzu";
	//
	// trace stop
	$trace_stop = 1;	// 0:trace run 1;trace stop
	//
	// footertag_insert_yuzu_tracesub("----","w");	// first trace
	// footertag_insert_yuzu_tracesub("data","a+");	// continue trace
	//
	if($trace_stop==0){
		$file = WP_PLUGIN_DIR."/".$myfolder."/snap.txt";
		$fp = fopen($file, $sw); 
		fwrite($fp, "$buf\n");
		fclose($fp); 
	}
}
/********************************************************/
// 設定
/********************************************************/
add_action( 'wp_footer', 'footertag_insert_yuzu_insert' );			

add_action('admin_menu' , 'footertag_insert_yuzu_control');			// WP設定画面に追加
/********************************************************/
function footertag_insert_yuzu_insert()
/********************************************************/
{
	$footertag_insert_yuzu_string_in = get_option('footertag_insert_yuzu_string_in');
	$footertag_insert_yuzu_stringI   = footertag_insert_yuzu_plantext($footertag_insert_yuzu_string_in);

	$footertag_insert_yuzu_string_ot = get_option('footertag_insert_yuzu_string_ot');
	$footertag_insert_yuzu_stringO   = footertag_insert_yuzu_plantext($footertag_insert_yuzu_string_ot);

	$footertag_insert_yuzu_string    = get_option('footertag_insert_yuzu_string');
	$footertag_insert_yuzu_stringV   = footertag_insert_yuzu_plantext($footertag_insert_yuzu_string);

	if ( is_user_logged_in() ){
		echo $footertag_insert_yuzu_stringI;
	}else{
		echo $footertag_insert_yuzu_stringO;
	}
	echo $footertag_insert_yuzu_stringV;
}
/********************************************************/
function footertag_insert_yuzu_unity($str,$cr)
/********************************************************/
{
	$str = str_replace("\r\n", "#cr#" , $str);
	$str = str_replace("\n"  , "#cr#" , $str);
	$str = str_replace("\r"  , "#cr#" , $str);
	$str = str_replace("#cr#",  $cr   , $str);
	return $str;
}
/********************************************************/
function footertag_insert_yuzu_control()
/********************************************************/
{
	add_options_page(
		'ゆずまるのフッタータグインサート',		// 1.設定画面での見出し
		'ゆずまるのフッタータグインサート',		// 2.設定->メニューでの名前
		'administrator',						// 3.アクセスレベル
		__FILE__,								// 4.決まり文句
		'footertag_insert_yuzu_entry'			// 5.設定の本体関数名
	);

}
/********************************************************/
function footertag_insert_yuzu_entry()
/********************************************************/
{

	echo "<h2>ゆずまるの フッタータグインサート ver ".footertag_insert_yuzu_ver().".</h2>";
	//----------------------------------------------------
	// 保存
	//----------------------------------------------------
	if( isset($_POST['action']) ){
		$footertag_insert_yuzu_string_in = $_POST['footertag_insert_yuzu_string_in'];
		$footertag_insert_yuzu_string_in = footertag_insert_yuzu_metatext($footertag_insert_yuzu_string_in);
		update_option('footertag_insert_yuzu_string_in', $footertag_insert_yuzu_string_in);

		$footertag_insert_yuzu_string_ot = $_POST['footertag_insert_yuzu_string_ot'];
		$footertag_insert_yuzu_string_ot = footertag_insert_yuzu_metatext($footertag_insert_yuzu_string_ot);
		update_option('footertag_insert_yuzu_string_ot', $footertag_insert_yuzu_string_ot);

		$footertag_insert_yuzu_string = $_POST['footertag_insert_yuzu_string'];
		$footertag_insert_yuzu_string = footertag_insert_yuzu_metatext($footertag_insert_yuzu_string);
		update_option('footertag_insert_yuzu_string', $footertag_insert_yuzu_string);
	}
	//----------------------------------------------------
	// 読み込み
	//----------------------------------------------------
	$footertag_insert_yuzu_string_in = get_option('footertag_insert_yuzu_string_in');
	$footertag_insert_yuzu_stringI   = $footertag_insert_yuzu_string_in ;

	$footertag_insert_yuzu_string_ot = get_option('footertag_insert_yuzu_string_ot');
	$footertag_insert_yuzu_stringO   = $footertag_insert_yuzu_string_ot ;

	$footertag_insert_yuzu_string    = get_option('footertag_insert_yuzu_string');
	$footertag_insert_yuzu_stringV   = $footertag_insert_yuzu_string ;
	//----------------------------------------------------
	// 表示
	//----------------------------------------------------
?>
<form method="post" action="">
	ログインしている場合のみ挿入<br />
	<textarea name="footertag_insert_yuzu_string_in" id="footertag_insert_yuzu_string_in" cols="80" rows="8"><?php echo $footertag_insert_yuzu_stringI; ?></textarea>
	<br />
	ログインしていない場合のみ挿入<br />
	<textarea name="footertag_insert_yuzu_string_ot" id="footertag_insert_yuzu_string_ot" cols="80" rows="8"><?php echo $footertag_insert_yuzu_stringO; ?></textarea>
	<br />
	ログインログアウト関係なく挿入<br />
	<textarea name="footertag_insert_yuzu_string" id="footertag_insert_yuzu_string" cols="80" rows="8"><?php echo $footertag_insert_yuzu_stringV; ?></textarea>
	<br />
	<p class="submit">
	<input type="submit" class="button-primary" name="action" value="<?php _e('Save Changes') ?>" />
	<input type="hidden" name="action" value="update" />

	</p>
</form>
<?php
}
/********************************************************/
function footertag_insert_yuzu_metatext($val)
/********************************************************/
{
	$val = str_replace('<','&lt;'   ,$val);
	$val = str_replace('>','&gt;'   ,$val);
	$val = str_replace('\"','&quot;',$val);
	$val = str_replace("\'",'&#39;' ,$val);
	return $val;
}
/********************************************************/
function footertag_insert_yuzu_plantext($val)
/********************************************************/
{
	$val = str_replace('&lt;'   , '<'  ,  $val);
	$val = str_replace('&gt;'   , '>'  ,  $val);
	$val = str_replace('&quot;' , '\"' ,  $val);
	$val = str_replace('&#39;'  , "\'" ,  $val);
	$val = str_replace('\"','"',$val);
	$val = str_replace("\'","'",$val);
	return $val;
}
?>
