<?php
/*
Plugin Name: ワードプレスのエクスポートファイル名の変更
Description: ワードプレスのエクスポートファイル名を出力ターゲット名を付けるように変更します。
Version: 2.40812
Author: yuzumaru
*/
/********************************************************/
function export_filename_change_yuzu_ver()
/********************************************************/
{
	// ------------------------
	// [ version 表記 ]
	// ------------------------
	return "2.40812";
	return "2.40811";
}
/********************************************************/
function export_filename_change_yuzu_name()
/********************************************************/
{
	// ------------------------
	// [ Plugin名 ]
	// ------------------------
	return "ワードプレスのエクスポートファイル名の変更";
}
/********************************************************/
function export_filename_change_yuzu_description()
/********************************************************/
{
	// ------------------------
	// [ Description ]
	// ------------------------
	return "ワードプレスのエクスポートファイル名を出力ターゲット名を付けるように変更します。";
}
/********************************************************/
function export_filename_change_yuzu_tracesub($mess,$p='a',$w='a')
/********************************************************/
{
	//
	// export_filename_change_yuzu_tracesub('---trace---','w');
	// export_filename_change_yuzu_tracesub($mess);
	// export_filename_change_yuzu_tracesub($mess,'w');
	//
	// export_filename_change_yuzu_tracesub($mess,'---stack mess---');			// when $mess is array. secnd para is array title.
	// export_filename_change_yuzu_tracesub($mess,'---stack mess---','w');		// when $mess is array. secnd para is array title.
	//
	// export_filename_change_yuzu_tracesub($smbl,'ABC_TRACE_FILE');			// $mess is no array. secnd para is trace file name
	// export_filename_change_yuzu_tracesub($smbl,'ABC_TRACE_FILE','w');		// $mess is no array. secnd para is trace file name
	//
	
	//return
	
	$file = plugin_dir_path(__FILE__)   .'export_filename_change_yuzu_log.cgi';		// 出力先 本プラグインフォルダー
	//$file = get_template_directory().'/'.'export_filename_change_yuzu_log.cgi';		// 出力先 現在使用中テーマ
	//$file = content_url()           .'/'.'export_filename_change_yuzu_log.cgi';		// 出力先 WP-CONTENTS/

	$head = '';
	if($p!='a' && $p!='w'){
		$head = $p;
		$p    = $w;
	}
	$fp = fopen($file,$p);
	if($p=='w'&&$mess==''){
	}else{
		if(is_array($mess)){
			fwrite($fp, $head."\n");
			fwrite($fp, print_r($mess, true));
			fwrite($fp, "/"."$head\n");
		}else{
			if($head!=''){
				fwrite($fp, $head.'='.$mess."\n");
			}else{
				fwrite($fp, $mess."\n");
			}
		}
	}
	fclose($fp);
}
/********************************************************/
// 設定
/********************************************************/
// apply_filters ->  add_filter
add_filter(   'export_wp_filename','export_filename_change_yuzu_filename');			// コンテンツ編集
add_action(   'admin_menu' ,'export_filename_change_yuzu_control');				// WP設定画面に追加
//export_filename_change_yuzu_tracesub('-- export_filename_change_yuzu snap --','w');
/********************************************************/
function export_filename_change_yuzu_filename($wp_filename='', $sitename='', $date='')// WP設定画面に追加
/********************************************************/
{
	$home_url=home_url();
	$home_str=explode('?',$home_url);
	$home_url=str_replace('http://','',$home_str[0]);
	$home_url=str_replace('https://','',$home_str[0]);
	$home_url=str_replace('/','_',$home_url);
	$home_url=str_replace('.','_',$home_url);
	
	$filepath = pathinfo($wp_filename);
	if($filepath['dirname']=='.'||$filepath['dirname']=='..'){
		$filepath['dirname']='';
	}
	$filename = $filepath['dirname'].$home_url.'.'.$filepath['filename'].'.'.$_GET['content'].'.'.$filepath['extension'];
	$filename = str_replace('WordPress.','',$filename);

	$g = get_the_generator( 'export' );
	
	//export_filename_change_yuzu_tracesub('---get_the_generator---','a');
	//export_filename_change_yuzu_tracesub($g,'a');

	//export_filename_change_yuzu_tracesub($filepath,'filename=','a');
	//export_filename_change_yuzu_tracesub('filename='.$filename,'a');


	export_filename_change_yuzu_filesave($filename);

	return($filename);

}
/********************************************************/
function export_filename_change_yuzu_filesave($wp_filename)			// WP設定画面に追加
/********************************************************/
{
	global $wpdb, $post;

	$args = array();
	foreach($_GET as $k => $v){
		$args[$k]=$v;
	}

	$defaults = array(
		'content'    => 'all',
		'author'     => false,
		'category'   => false,
		'start_date' => false,
		'end_date'   => false,
		'status'     => false,
	);
	$args     = wp_parse_args( $args, $defaults );

	//export_filename_change_yuzu_tracesub('---export_filename_change_yuzu_filesave---','a');

	if ( 'all' !== $args['content'] && post_type_exists( $args['content'] ) ) {
		$ptype = get_post_type_object( $args['content'] );
		if ( ! $ptype->can_export ) {
			$_GET['content'] = 'post';
		}

		$where = $wpdb->prepare( "{$wpdb->posts}.post_type = %s", $args['content'] );
	} else {
		$post_types = get_post_types( array( 'can_export' => true ) );
		$esses      = array_fill( 0, count( $post_types ), '%s' );
		// phpcs:ignore WordPress.DB.PreparedSQLPlaceholders.UnfinishedPrepare
		$where = $wpdb->prepare( "{$wpdb->posts}.post_type IN (" . implode( ',', $esses ) . ')', $post_types );
	}

	if ( $args['status'] && ( 'post' === $args['content'] || 'page' === $args['content'] ) ) {
		$where .= $wpdb->prepare( " AND {$wpdb->posts}.post_status = %s", $args['status'] );
	} else {
		$where .= " AND {$wpdb->posts}.post_status != 'auto-draft'";
	}

	$join = '';
	if ( $args['category'] && 'post' === $args['content'] ) {
		$term = term_exists( $args['category'], 'category' );
		if ( $term ) {
			$join   = "INNER JOIN {$wpdb->term_relationships} ON ({$wpdb->posts}.ID = {$wpdb->term_relationships}.object_id)";
			$where .= $wpdb->prepare( " AND {$wpdb->term_relationships}.term_taxonomy_id = %d", $term['term_taxonomy_id'] );
		}
	}

	if ( in_array( $args['content'], array( 'post', 'page', 'attachment' ), true ) ) {
		if ( $args['author'] ) {
			$where .= $wpdb->prepare( " AND {$wpdb->posts}.post_author = %d", $args['author'] );
		}

		if ( $args['start_date'] ) {
			$where .= $wpdb->prepare( " AND {$wpdb->posts}.post_date >= %s", gmdate( 'Y-m-d', strtotime( $args['start_date'] ) ) );
		}

		if ( $args['end_date'] ) {
			$where .= $wpdb->prepare( " AND {$wpdb->posts}.post_date < %s", gmdate( 'Y-m-d', strtotime( '+1 month', strtotime( $args['end_date'] ) ) ) );
		}
	}

	// Grab a snapshot of post IDs, just in case it changes during the export.
	$post_ids = $wpdb->get_col( "SELECT ID FROM {$wpdb->posts} $join WHERE $where" );

	$doc = '';
	$doc.= '<?xml version="1.0" encoding="' . get_bloginfo( 'charset' ) . "\" ?>\n";
	$doc.= get_the_generator( 'export' );
	$doc.= '<rss version="2.0"'."\n";
	$doc.= '	xmlns:excerpt="http://wordpress.org/export/'.WXR_VERSION.'/excerpt/"'."\n";
	$doc.= '	xmlns:content="http://purl.org/rss/1.0/modules/content/"'."\n";
	$doc.= '	xmlns:wfw="http://wellformedweb.org/CommentAPI/"'."\n";
	$doc.= '	xmlns:dc="http://purl.org/dc/elements/1.1/"'."\n";
	$doc.= '	xmlns:wp="http://wordpress.org/export/<?php echo WXR_VERSION; ?>/"'."\n";
	$doc.= ''."\n";
	$doc.= '<channel>'."\n";
	$doc.= '	<title>'.get_bloginfo_rss( 'name' ).'</title>'."\n";
	$doc.= '	<link>'.get_bloginfo_rss( 'url' ).'</link>'."\n";
	$doc.= '	<description>'.get_bloginfo_rss( 'description' ).'</description>'."\n";
	$doc.= '	<pubDate>'.gmdate( 'D, d M Y H:i:s +0000' ).'</pubDate>'."\n";
	$doc.= '	<language>'.get_bloginfo_rss( 'language' ).'</language>'."\n";
	$doc.= '	<wp:wxr_version>'.WXR_VERSION.'</wp:wxr_version>'."\n";
	$doc.= '	<wp:base_site_url>'.export_filename_change_yuzu_wxr_site_url().'</wp:base_site_url>'."\n";
	$doc.= '	<wp:base_blog_url>'.get_bloginfo_rss( 'url' ).'</wp:base_blog_url>'."\n";
	$doc.= ''."\n";
	$doc.= export_filename_change_yuzu_wxr_authors_list( $post_ids )."\n";

	foreach ( $cats as $c ) :
	$doc.= '	<wp:category>'."\n";
	$doc.= '		<wp:term_id>'.(int)$c->term_id.'</wp:term_id>'."\n";
	$doc.= '		<wp:category_nicename>'.export_filename_change_yuzu_wxr_cdata( $c->slug ).'</wp:category_nicename>'."\n";
	$doc.= '		<wp:category_parent>'.export_filename_change_yuzu_wxr_cdata( $c->parent ? $cats[ $c->parent ]->slug : '').'</wp:category_parent>'."\n";
	$doc.= export_filename_change_yuzu_wxr_cat_name( $c );
	$doc.= export_filename_change_yuzu_wxr_category_description( $c );
	$doc.= export_filename_change_yuzu_wxr_term_meta( $c );
	$doc.= '	</wp:category>'."\n";
	endforeach;
	foreach ( $tags as $t ) :
	$doc.= '	<wp:tag>'."\n";
	$doc.= '		<wp:term_id>'.(int)$t->term_id.'</wp:term_id>'."\n";
	$doc.= '		<wp:tag_slug>'.export_filename_change_yuzu_wxr_cdata( $t->slug ).'</wp:tag_slug>'."\n";

	$doc.= export_filename_change_yuzu_wxr_tag_name( $t );
	$doc.= export_filename_change_yuzu_wxr_tag_description( $t );
	$doc.= export_filename_change_yuzu_wxr_term_meta( $t );
	$doc.= '	</wp:tag>'."\n";
	endforeach;
	foreach ( $terms as $t ) :
	$doc.= '	<wp:term>'."\n";
	$doc.= '		<wp:term_id>'.(int)$t->term_id.'</wp:term_id>'."\n";
	$doc.= '		<wp:term_taxonomy>'.export_filename_change_yuzu_wxr_cdata( $t->taxonomy ).'</wp:term_taxonomy>'."\n";
	$doc.= '		<wp:term_slug>'.export_filename_change_yuzu_wxr_cdata( $t->slug ).'</wp:term_slug>'."\n";
	$doc.= '		<wp:term_parent>'.export_filename_change_yuzu_wxr_cdata( $t->parent ? $terms[ $t->parent ]->slug :'') .'</wp:term_parent>'."\n";
	$doc.= export_filename_change_yuzu_wxr_term_name( $t );
	$doc.= export_filename_change_yuzu_wxr_term_description( $t );
	$doc.= export_filename_change_yuzu_wxr_term_meta( $t );
	$doc.= '	</wp:term>'."\n";
	endforeach;
	if('all'===$args['content']){
		$doc.= export_filename_change_yuzu_wxr_nav_menu_terms();
	}
	/** This action is documented in wp-includes/feed-rss2.php */
	do_action( 'rss2_head' );

	if ( $post_ids ) {
		/**
		 * @global WP_Query $wp_query WordPress Query object.
		 */
		global $wp_query;

		// Fake being in the loop.
		$wp_query->in_the_loop = true;

		// Fetch 20 posts at a time rather than loading the entire table into memory.
		while ( $next_posts = array_splice( $post_ids, 0, 20 ) ) {
			$where = 'WHERE ID IN (' . implode( ',', $next_posts ) . ')';
			$posts = $wpdb->get_results( "SELECT * FROM {$wpdb->posts} $where" );

			// Begin Loop.
			foreach ( $posts as $post ) {
				setup_postdata( $post );

				/**
				 * Filters the post title used for WXR exports.
				 *
				 * @since 5.7.0
				 *
				 * @param string $post_title Title of the current post.
				 */
				$title = export_filename_change_yuzu_wxr_cdata( apply_filters( 'the_title_export', $post->post_title ) );

				/**
				 * Filters the post content used for WXR exports.
				 *
				 * @since 2.5.0
				 *
				 * @param string $post_content Content of the current post.
				 */
				$content = export_filename_change_yuzu_wxr_cdata( apply_filters( 'the_content_export', $post->post_content ) );

				/**
				 * Filters the post excerpt used for WXR exports.
				 *
				 * @since 2.6.0
				 *
				 * @param string $post_excerpt Excerpt for the current post.
				 */
				$excerpt = export_filename_change_yuzu_wxr_cdata( apply_filters( 'the_excerpt_export', $post->post_excerpt ) );

				$is_sticky = is_sticky( $post->ID ) ? 1 : 0;
	$doc.= '	<item>'."\n";
	$doc.= '		<title>'.$title.'</title>'."\n";
	$doc.= '		<link>'.export_filename_change_yuzu_the_permalink_rss().'</link>'."\n";
	$doc.= '		<pubDate>'.mysql2date( 'D, d M Y H:i:s +0000', get_post_time( 'Y-m-d H:i:s', true ), false ).'</pubDate>'."\n";
	$doc.= '		<dc:creator>'.export_filename_change_yuzu_wxr_cdata( get_the_author_meta( 'login' ) ).'</dc:creator>'."\n";
	$doc.= '		<guid isPermaLink="false">'.get_the_guid().'</guid>'."\n";
	$doc.= '		<description></description>'."\n";
	$doc.= '		<content:encoded>'.$content.'</content:encoded>'."\n";
	$doc.= '		<excerpt:encoded>'.$excerpt.'</excerpt:encoded>'."\n";
	$doc.= '		<wp:post_id>'.(int)$post->ID.'</wp:post_id>'."\n";
	$doc.= '		<wp:post_date>'.export_filename_change_yuzu_wxr_cdata( $post->post_date ).'</wp:post_date>'."\n";
	$doc.= '		<wp:post_date_gmt>'.export_filename_change_yuzu_wxr_cdata( $post->post_date_gmt ).'</wp:post_date_gmt>'."\n";
	$doc.= '		<wp:post_modified>'.export_filename_change_yuzu_wxr_cdata( $post->post_modified ).'</wp:post_modified>'."\n";
	$doc.= '		<wp:post_modified_gmt>'.export_filename_change_yuzu_wxr_cdata( $post->post_modified_gmt ).'</wp:post_modified_gmt>'."\n";
	$doc.= '		<wp:comment_status>'.export_filename_change_yuzu_wxr_cdata( $post->comment_status ).'</wp:comment_status>'."\n";
	$doc.= '		<wp:ping_status>'.export_filename_change_yuzu_wxr_cdata( $post->ping_status ).'</wp:ping_status>'."\n";
	$doc.= '		<wp:post_name>'.export_filename_change_yuzu_wxr_cdata( $post->post_name ).'</wp:post_name>'."\n";
	$doc.= '		<wp:status>'.export_filename_change_yuzu_wxr_cdata( $post->post_status ).'</wp:status>'."\n";
	$doc.= '		<wp:post_parent>'.(int)$post->post_parent.'</wp:post_parent>'."\n";
	$doc.= '		<wp:menu_order>'.(int)$post->menu_order.'</wp:menu_order>'."\n";
	$doc.= '		<wp:post_type>'.export_filename_change_yuzu_wxr_cdata( $post->post_type ).'</wp:post_type>'."\n";
	$doc.= '		<wp:post_password>'.export_filename_change_yuzu_wxr_cdata( $post->post_password ).'</wp:post_password>'."\n";
	$doc.= '		<wp:is_sticky>'.(int)$is_sticky.'</wp:is_sticky>'."\n";
				if ( 'attachment' === $post->post_type ) :
	$doc.= '		<wp:attachment_url>'.export_filename_change_yuzu_wxr_cdata( wp_get_attachment_url( $post->ID ) ).'</wp:attachment_url>'."\n";
				endif;
	$doc.= export_filename_change_yuzu_wxr_post_taxonomy();
				$postmeta = $wpdb->get_results( $wpdb->prepare( "SELECT * FROM $wpdb->postmeta WHERE post_id = %d", $post->ID ) );
				foreach ( $postmeta as $meta ) :
					if ( apply_filters( 'wxr_export_skip_postmeta', false, $meta->meta_key, $meta ) ) {
						continue;
					}
	$doc.= '		<wp:postmeta>'."\n";
	$doc.= '		<wp:meta_key>'.export_filename_change_yuzu_wxr_cdata( $meta->meta_key ).'</wp:meta_key>'."\n";
	$doc.= '		<wp:meta_value>'.export_filename_change_yuzu_wxr_cdata( $meta->meta_value ).'</wp:meta_value>'."\n";
	$doc.= '		</wp:postmeta>'."\n";
				endforeach;

				$_comments = $wpdb->get_results( $wpdb->prepare( "SELECT * FROM $wpdb->comments WHERE comment_post_ID = %d AND comment_approved <> 'spam'", $post->ID ) );
				$comments  = array_map( 'get_comment', $_comments );
				foreach ( $comments as $c ) :
	$doc.= '		<wp:comment>'."\n";
	$doc.= '			<wp:comment_id>'.(int)$c->comment_ID.'</wp:comment_id>'."\n";
	$doc.= '			<wp:comment_author>'.export_filename_change_yuzu_wxr_cdata( $c->comment_author ).'</wp:comment_author>'."\n";
	$doc.= '			<wp:comment_author_email>'.export_filename_change_yuzu_wxr_cdata( $c->comment_author_email ).'</wp:comment_author_email>'."\n";
	$doc.= '			<wp:comment_author_url>'.sanitize_url( $c->comment_author_url ).'</wp:comment_author_url>'."\n";
	$doc.= '			<wp:comment_author_IP>'.export_filename_change_yuzu_wxr_cdata( $c->comment_author_IP ).'</wp:comment_author_IP>'."\n";
	$doc.= '			<wp:comment_date>'.export_filename_change_yuzu_wxr_cdata( $c->comment_date ).'</wp:comment_date>'."\n";
	$doc.= '			<wp:comment_date_gmt>'.export_filename_change_yuzu_wxr_cdata( $c->comment_date_gmt ).'</wp:comment_date_gmt>'."\n";
	$doc.= '			<wp:comment_content>'.export_filename_change_yuzu_wxr_cdata( $c->comment_content ).'</wp:comment_content>'."\n";
	$doc.= '			<wp:comment_approved>'.export_filename_change_yuzu_wxr_cdata( $c->comment_approved ).'</wp:comment_approved>'."\n";
	$doc.= '			<wp:comment_type>'.export_filename_change_yuzu_wxr_cdata( $c->comment_type ).'</wp:comment_type>'."\n";
	$doc.= '			<wp:comment_parent>'.(int)$c->comment_parent.'</wp:comment_parent>'."\n";
	$doc.= '			<wp:comment_user_id>'.(int)$c->user_id.'</wp:comment_user_id>'."\n";
					$c_meta = $wpdb->get_results( $wpdb->prepare( "SELECT * FROM $wpdb->commentmeta WHERE comment_id = %d", $c->comment_ID ) );
					foreach ( $c_meta as $meta ) :
						/**
						 * Filters whether to selectively skip comment meta used for WXR exports.
						 *
						 * Returning a truthy value from the filter will skip the current meta
						 * object from being exported.
						 *
						 * @since 4.0.0
						 *
						 * @param bool   $skip     Whether to skip the current comment meta. Default false.
						 * @param string $meta_key Current meta key.
						 * @param object $meta     Current meta object.
						 */
						if ( apply_filters( 'wxr_export_skip_commentmeta', false, $meta->meta_key, $meta ) ) {
							continue;
						}
	$doc.='	<wp:commentmeta>'."\n";
	$doc.='	<wp:meta_key>'.export_filename_change_yuzu_wxr_cdata( $meta->meta_key ).'</wp:meta_key>'."\n";
	$doc.='			<wp:meta_value>'.export_filename_change_yuzu_wxr_cdata( $meta->meta_value ).'</wp:meta_value>'."\n";
	$doc.='			</wp:commentmeta>'."\n";
					endforeach;
	$doc.='		</wp:comment>'."\n";
				endforeach;
	$doc.='		</item>'."\n";
			}
		}
	}
	$doc.='</channel>'."\n";
	$doc.='</rss>'."\n";


	$pfile = plugin_dir_path(__FILE__)   .$wp_filename;		// 出力先 本プラグインフォルダー
	$tfile = get_template_directory().'/'.$wp_filename;		// 出力先 現在使用中テーマ
	$cfile = content_url()           .'/'.$wp_filename;		// 出力先 WP-CONTENTS/
	export_filename_change_yuzu_xmlsave($pfile,$doc);

	return($doc);
}
/********************************************************/
function export_filename_change_yuzu_wxr_cdata( $str )
/********************************************************/
{
	if ( ! seems_utf8( $str ) ) {
		$str = utf8_encode( $str );
	}
	// $str = ent2ncr(esc_html($str));
	$str = '<![CDATA[' . str_replace( ']]>', ']]]]><![CDATA[>', $str ) . ']]>';

	return $str;
}
/********************************************************/
function export_filename_change_yuzu_wxr_site_url()
/********************************************************/
{
	if ( is_multisite() ) {
		// Multisite: the base URL.
		return network_home_url();
	} else {
		// WordPress (single site): the site URL.
		return get_bloginfo_rss( 'url' );
	}
}
/********************************************************/
function export_filename_change_yuzu_xmlsave( $file,$doc )
/********************************************************/
{
	//export_filename_change_yuzu_tracesub('---export_filename_change_yuzu_xmlsave---','a');
	//export_filename_change_yuzu_tracesub('file='.$file,'a');

	$p='w';
	$fp = fopen($file,$p);
	fwrite($fp, $doc);
	fclose($fp);
}
/********************************************************/
function export_filename_change_yuzu_wxr_tag_name( $tag )
/********************************************************/
{
	if ( empty( $tag->name ) ) {
		return('');
	}
	return('<wp:tag_name>' . export_filename_change_yuzu_wxr_cdata( $tag->name ) . "</wp:tag_name>\n" );
}
/********************************************************/
function export_filename_change_yuzu_wxr_tag_description( $tag )
/********************************************************/
{
	if ( empty( $tag->description ) ) {
		return('');
	}
	return( '<wp:tag_description>' . export_filename_change_yuzu_wxr_cdata( $tag->description ) . "</wp:tag_description>\n");
}
/********************************************************/
function export_filename_change_yuzu_wxr_term_meta( $term )
/********************************************************/
{
	global $wpdb;

	$termmeta = $wpdb->get_results( $wpdb->prepare( "SELECT * FROM $wpdb->termmeta WHERE term_id = %d", $term->term_id ) );

	foreach( $termmeta as $meta ) {
		if( !apply_filters( 'wxr_export_skip_termmeta', false, $meta->meta_key, $meta ) ) {
			return(fprintf( "\t\t<wp:termmeta>\n\t\t\t<wp:meta_key>%s</wp:meta_key>\n\t\t\t<wp:meta_value>%s</wp:meta_value>\n\t\t</wp:termmeta>\n", export_filename_change_yuzu_wxr_cdata( $meta->meta_key ), export_filename_change_yuzu_wxr_cdata( $meta->meta_value ) ));
		}
	}
	return('');
}
/********************************************************/
function export_filename_change_yuzu_wxr_term_name( $term )
/********************************************************/
{
	if ( empty( $term->name ) ) {
		return;
	}
	return('<wp:term_name>' . export_filename_change_yuzu_wxr_cdata( $term->name ) . "</wp:term_name>\n");
}
/********************************************************/
function export_filename_change_yuzu_wxr_term_description( $term )
/********************************************************/
{
	if ( empty( $term->description ) ) {
		return;
	}
	return( "\t\t<wp:term_description>" . export_filename_change_yuzu_wxr_cdata( $term->description ) . "</wp:term_description>\n" );
}
/********************************************************/
function export_filename_change_yuzu_wxr_nav_menu_terms()
/********************************************************/
{
	$nav_menus = wp_get_nav_menus();
	if ( empty( $nav_menus ) || ! is_array( $nav_menus ) ) {
		return;
	}
	$doc = '';
	foreach ( $nav_menus as $menu ) {
		$doc.= "\t<wp:term>";
		$doc.= '	<wp:term_id>' . (int) $menu->term_id . '</wp:term_id>';
		$doc.= '	<wp:term_taxonomy>nav_menu</wp:term_taxonomy>';
		$doc.= '	<wp:term_slug>' . export_filename_change_yuzu_wxr_cdata( $menu->slug ) . '</wp:term_slug>';
		$doc.= export_filename_change_yuzu_wxr_term_name( $menu );
		$doc = "</wp:term>\n";
	}
	return($doc);
}
/********************************************************/
function export_filename_change_yuzu_the_permalink_rss()
/********************************************************/
{
	/**
	 * Filters the permalink to the post for use in feeds.
	 *
	 * @since 2.3.0
	 *
	 * @param string $post_permalink The current post permalink.
	 */
	return( esc_url( apply_filters( 'the_permalink_rss', get_permalink() ) ) );
}
/********************************************************/
function export_filename_change_yuzu_wxr_post_taxonomy()
/********************************************************/
{
	$post = get_post();

	$taxonomies = get_object_taxonomies( $post->post_type );
	if ( empty( $taxonomies ) ) {
		return('');
	}
	$terms = wp_get_object_terms( $post->ID, $taxonomies );

	foreach ( (array) $terms as $term ) {
		return( "\t\t<category domain=\"{$term->taxonomy}\" nicename=\"{$term->slug}\">" . export_filename_change_yuzu_wxr_cdata( $term->name ) . "</category>\n");
	}
}
/********************************************************/
function export_filename_change_yuzu_wxr_category_description( $category )
/********************************************************/
{
	if ( empty( $category->description ) ) {
		return;
	}

	return( '<wp:category_description>' . export_filename_change_yuzu_wxr_cdata( $category->description ) . "</wp:category_description>\n");
}
/********************************************************/
function export_filename_change_yuzu_wxr_cat_name( $category )
/********************************************************/
{
	if ( empty( $category->name ) ) {
		return;
	}
	return( '<wp:cat_name>' . export_filename_change_yuzu_wxr_cdata( $category->name ) . "</wp:cat_name>\n");
}
/********************************************************/
function export_filename_change_yuzu_wxr_authors_list( array $post_ids = null )
/********************************************************/
{
	global $wpdb;

	if ( ! empty( $post_ids ) ) {
		$post_ids = array_map( 'absint', $post_ids );
		$and      = 'AND ID IN ( ' . implode( ', ', $post_ids ) . ')';
	} else {
		$and = '';
	}

	$authors = array();
	$results = $wpdb->get_results( "SELECT DISTINCT post_author FROM $wpdb->posts WHERE post_status != 'auto-draft' $and" );
	foreach ( (array) $results as $result ) {
		$authors[] = get_userdata( $result->post_author );
	}

	$authors = array_filter( $authors );

	$doc = '';
	foreach ( $authors as $author ) {
		$doc.= "\t<wp:author>";
		$doc.= '<wp:author_id>' . (int) $author->ID . '</wp:author_id>';
		$doc.= '<wp:author_login>' . export_filename_change_yuzu_wxr_cdata( $author->user_login ) . '</wp:author_login>';
		$doc.= '<wp:author_email>' . export_filename_change_yuzu_wxr_cdata( $author->user_email ) . '</wp:author_email>';
		$doc.= '<wp:author_display_name>' . export_filename_change_yuzu_wxr_cdata( $author->display_name ) . '</wp:author_display_name>';
		$doc.= '<wp:author_first_name>' . export_filename_change_yuzu_wxr_cdata( $author->first_name ) . '</wp:author_first_name>';
		$doc.= '<wp:author_last_name>' . export_filename_change_yuzu_wxr_cdata( $author->last_name ) . '</wp:author_last_name>';
		$doc.= "</wp:author>\n";
	}
	return($doc);
}

/********************************************************/
function export_filename_change_yuzu_control()			// WP設定画面に追加
/********************************************************/
{
	add_options_page(
		export_filename_change_yuzu_name()		,	// 1.設定画面での見出し
		export_filename_change_yuzu_name()		,	// 2.設定->メニューでの名前
		'administrator'					,	// 3.アクセスレベル
		__FILE__						,	// 4.決まり文句
		'export_filename_change_yuzu_entry'			// 5.設定の本体関数名
	);
}
/********************************************************/
function export_filename_change_yuzu_entry()
/********************************************************/
{
	echo "<h2>".export_filename_change_yuzu_name()." ver ".export_filename_change_yuzu_ver().".</h2>";
	//----------------------------------------------------
	// 保存
	//----------------------------------------------------
	if( isset($_POST['action']) ){
//		$export_filename_change_yuzu_title   = $_POST['export_filename_change_yuzu_title'];
//		$export_filename_change_yuzu_title   = export_filename_change_yuzu_metatext($export_filename_change_yuzu_title);
//		update_option('export_filename_change_yuzu_title', $export_filename_change_yuzu_title);
	}
	//----------------------------------------------------
	// 読み込み (入力用)
	// '<' 等の通常文字を '&lt;' 特殊文字に変換して使用する
	//----------------------------------------------------
//	$export_filename_change_yuzu_title   = get_option('export_filename_change_yuzu_title');
//	if($export_filename_change_yuzu_title==''){ $export_filename_change_yuzu_title = export_filename_change_yuzu_default('export_filename_change_yuzu_title'); }	//デフォルト設定
	$export_filename_change_yuzu_titleV  = export_filename_change_yuzu_metatext( $post_date_sort_yuzu_title );
	//----------------------------------------------------
	// 読み込み (表示系プロセスで使用する場合) 
	// '&lt;' 等の特殊文字を '<' 通常文字に変換して使用する
	//----------------------------------------------------
	//$export_filename_change_yuzu_title = get_option('export_filename_change_yuzu_title');
	//if($export_filename_change_yuzu_title==''){ $export_filename_change_yuzu_title = export_filename_change_yuzu_default('export_filename_change_yuzu_title'); }	//デフォルト設定
	//$export_filename_change_yuzu_title = export_filename_change_yuzu_plantext( $post_date_sort_yuzu_title );
	//----------------------------------------------------
	// 表示準備
	//----------------------------------------------------

	//----------------------------------------------------
	// 表示
	//----------------------------------------------------
?>
<table style="width:80%;">
<form method="post" action="">
	<tr>
		<td align="" style="font-weight:bold;font-size:120%;">
			<?php echo export_filename_change_yuzu_description(); ?>
		</td>
	</tr>
	<tr>
		<td align="" style="">
			<?php echo ''; ?>
		</td>
	</tr>
<!-- Button 
	<tr>
		<td colspan="2"align="center">
			<p style="text-align:right;">
				<input type="submit" class="button-primary" name="action" value="<?php _e('Save Changes') ?>" />
				<input type="hidden" name="action" value="update" />
			</p>
		</td>
	</tr>
-->
</form>
</table>
<?php
}
/********************************************************/
function export_filename_change_yuzu_default($smbl)
/********************************************************/
{
//	if($smbl=='export_filename_change_yuzu_title'){
//		return('ニュースとお知らせ');
//	}
	return('');
}
/********************************************************/
function export_filename_change_yuzu_cr($str,$cr)
/********************************************************/
{
	//
	// 改行の統一
	//
	$str = str_replace("\r\n", "#cr#" , $str);
	$str = str_replace("\n"  , "#cr#" , $str);
	$str = str_replace("\r"  , "#cr#" , $str);
	$str = str_replace("#cr#",  $cr   , $str);
	return $str;
}
/********************************************************/
function export_filename_change_yuzu_metatext($val)
/********************************************************/
{
	$val = str_replace('<','&lt;'   ,$val);
	$val = str_replace('>','&gt;'   ,$val);
	$val = str_replace('\"','&quot;',$val);
	$val = str_replace("\'",'&#39;' ,$val);
	return $val;
}
/********************************************************/
function export_filename_change_yuzu_plantext($val)
/********************************************************/
{
	$val = str_replace('&lt;'   , '<'  ,  $val);
	$val = str_replace('&gt;'   , '>'  ,  $val);
	$val = str_replace('&quot;' , '\"' ,  $val);
	$val = str_replace('&#39;'  , "\'" ,  $val);
	$val = str_replace('\"','"',$val);
	$val = str_replace("\'","'",$val);
	// &&?; で ? の表示
	$s=0;
	$p=strpos($val,'&&',$s);
	while( $p!==false ){
		$s = $p+2;
		if(substr($val,$p+3,1)==';'){
			$f = substr($val, 0,$p).substr($val,$p+2,1);
			$s = strlen($f);
			$b = substr($val,$p+4);
			$val = $f.$b;
		}
		$p=strpos($val,'&&',$s);
	}
	return $val;
}
?>
