<?php
/*
Plugin Name: ワードプレス アンインストール
Description: ワードプレスをアンインストールします。(アンインストールするとこのファイルも削除されます。)
Version: 2.40816
Author: yuzumaru
*/
/********************************************************/
function wp_uninstall_yuzu_ver()
/********************************************************/
{
	// ------------------------
	// [ version 表記 ]
	// ------------------------
	return "2.40816";
	return "2.40815";
	return "2.40814";
	return "2.40716";
	return "2.40715";
}
/********************************************************/
function wp_uninstall_yuzu_name()
/********************************************************/
{
	// ------------------------
	// [ Plugin名 ]
	// ------------------------
	return "ワードプレスアンインストール";
}
/********************************************************/
function wp_uninstall_yuzu_description()
/********************************************************/
{
	// ------------------------
	// [ Description ]
	// ------------------------
	return "ワードプレスをアンインストールします。(アンインストールするとこのファイルも削除されます。)";
}
/********************************************************/
function wp_uninstall_yuzu_tracesub($mess,$p='a',$w='a')
/********************************************************/
{
	//
	// wp_uninstall_yuzu_tracesub('---trace---','w');
	// wp_uninstall_yuzu_tracesub($mess);
	// wp_uninstall_yuzu_tracesub($mess,'w');
	//
	// wp_uninstall_yuzu_tracesub($mess,'---stack mess---');			// when $mess is array. secnd para is array title.
	// wp_uninstall_yuzu_tracesub($mess,'---stack mess---','w');		// when $mess is array. secnd para is array title.
	//
	// wp_uninstall_yuzu_tracesub($smbl,'ABC_TRACE_FILE');			// $mess is no array. secnd para is trace file name
	// wp_uninstall_yuzu_tracesub($smbl,'ABC_TRACE_FILE','w');		// $mess is no array. secnd para is trace file name
	//
	
	//return
	
	$file = plugin_dir_path(__FILE__)   .$p.'_log.cgi';		// 出力先 本プラグインフォルダー
	//$file = get_template_directory().'/'.$p.'_log.cgi';		// 出力先 現在使用中テーマ
	//$file = content_url()           .'/'.$p.'_log.cgi';		// 出力先 WP-CONTENTS/

	$head = '';
	if($p!='a' && $p!='w'){
		$head = $p;
		$p    = $w;
	}
	$fp = fopen($file,$p);
	if($p=='w'&&$mess==''){
	}else{
		if(is_array($mess)){
			fwrite($fp, $head."\n");
			fwrite($fp, print_r($mess, true));
			fwrite($fp, "/"."$head\n");
		}else{
			if($head!=''){
				fwrite($fp, $head.'='.$mess."\n");
			}else{
				fwrite($fp, $mess."\n");
			}
		}
	}
	fclose($fp);
}
/********************************************************/
// 設定
/********************************************************/
// apply_filters ->  add_filter
remove_filter('the_content','wp_uninstall_yuzu_content');			// コンテンツ編集
add_filter(   'the_content','wp_uninstall_yuzu_content');			// コンテンツ編集
add_action(   'admin_menu' ,'wp_uninstall_yuzu_control');				// WP設定画面に追加
add_shortcode('wp_uninstall_yuzu'  , 'wp_uninstall_yuzu_Shortcode');		// ショートコード
/********************************************************/
function wp_uninstall_yuzu_Shortcode($atts)
/********************************************************/
{
	// [shortCode year=xxxx month=xx ・・・]
	extract(shortcode_atts(array(
		'year'     => date('Y'),	// 開始年
		'month'    => date('m'),	// 開始月
		'count'    => "1",			// 繰り返し回数
		'eng'      => "",			// english : y
	), $atts));

//		：
//		：
//	$a0 = $year;
//	$a1 = $month;
//	$a2 = $count;
//	$a3 = $eng;
//		：
//		：

	return($replace_data);
}
/********************************************************/
function wp_uninstall_yuzu_content($content)	// コンテンツ編集
/********************************************************/
{
	
	return($content);
}
/********************************************************/
function wp_uninstall_yuzu_control()			// WP設定画面に追加
/********************************************************/
{
	add_options_page(
		wp_uninstall_yuzu_name()		,	// 1.設定画面での見出し
		wp_uninstall_yuzu_name()		,	// 2.設定->メニューでの名前
		'administrator'					,	// 3.アクセスレベル
		__FILE__						,	// 4.決まり文句
		'wp_uninstall_yuzu_entry'			// 5.設定の本体関数名
	);
}
/********************************************************/
function wp_uninstall_yuzu_entry()
/********************************************************/
{
	echo "<h2>".wp_uninstall_yuzu_name()." ver ".wp_uninstall_yuzu_ver().".</h2>";


	//----------------------------------------------------
	// Default
	//----------------------------------------------------
	$wpPath  = ABSPATH;
	$php_v   = phpversion();

	global $wpdb;
	$db_name = $wpdb->dbname;		//データベース名の取得
	$db_user = $wpdb->dbuser;		//データベース接続ユーザーの取得
	$db_pass = $wpdb->dbpassword;	//データベース接続用パスワードの取得
	$db_host = $wpdb->dbhost;		//データベースホストの取得
	$db_pfix = $wpdb->prefix;		//データベースホストの取得
	//----------------------------------------------------
	// 保存
	//----------------------------------------------------
	$message = '';
	if( isset($_POST['action']) ){
		$message.= $wpPath . 'のワードプレススクリプト<br />データベース '.$db_name.' 内の テーブルプレフィックス '.$db_pfix.'のテーブルは削除しました。<br />';
		$message.= '<br />';
		$message.= '<a href="'.site_url().'">'.site_url().'</a>';
	}
	//----------------------------------------------------
	// 読み込み (入力用)
	// '<' -> '&lt;' …
	//----------------------------------------------------
//	$wp_uninstall_yuzu_title   = get_option('wp_uninstall_yuzu_title');
//	if($wp_uninstall_yuzu_title==''){ $wp_uninstall_yuzu_title = "お願いと注意事項"; }
	if(!isset($post_date_sort_yuzu_title)){$post_date_sort_yuzu_title='';}
	$wp_uninstall_yuzu_titleV  = wp_uninstall_yuzu_metatext( $post_date_sort_yuzu_title );
	//----------------------------------------------------
	// 読み込み (使用時) 
	// '&lt;' -> '<' …
	//----------------------------------------------------
//	$wp_uninstall_yuzu_title   = get_option('wp_uninstall_yuzu_title');
//	if($wp_uninstall_yuzu_title==''){ $wp_uninstall_yuzu_title = "お願いと注意事項"; }
//	$wp_uninstall_yuzu_titleV  = wp_uninstall_yuzu_plantext( $post_date_sort_yuzu_title );
	//----------------------------------------------------
	// 表示準備
	//----------------------------------------------------
	
	//----------------------------------------------------
	// 表示
	//----------------------------------------------------
?>
<table style="width:80%;">
<form method="post" action="">
<?php
	if($message != '' ){
?>
	<tr>
		<td align="" style="font-size:120%;color:#c00;">
			<?php echo $message; ?>
		</td>
	</tr>
<?php
		$test = 0;
		if( isset($_POST['action']) ){
			$act = 0;
			if(!isset($_POST['alldel'])){$_POST['alldel'] ='';}
			if( $_POST['alldel'] !='' ){
				$act = 1;
			}
			if($test==0){
				$dir = $wpPath;
				
				// --- INFO SAVE ---
				wp_uninstall_yuzu__save_info($dir);
				
				// --- SCRIPT DELETE ---
				wp_uninstall_yuzu_remove_directory($dir,$act,0);
				
				// --- TABLE DELETE ---
				$tables = wp_uninstall_yuzu_shortcode_MySQLConnect($php_v,'tabledelete');
				foreach($tables as $tbl){
					echo $tbl.'<br />';
				}
			}
			exit;
		}
	}else{
?>
	<tr>
		<td align="" style="font-size:120%;">
			<?php echo 'WpPath:'.$wpPath; ?>
		</td>
	</tr>
	<tr>
		<td align="" style="font-size:120%;">
			<?php echo 'Php:'.$php_v; ?><br />
			--- MySql ---<br />
			<?php echo 'name:'.$db_name; ?><br />
			<?php echo 'user:'.$db_user; ?><br />
			<?php echo 'pass:'.$db_pass; ?><br />
			<?php echo 'host:'.$db_host; ?><br />
			<?php echo 'pfix:'.$db_pfix; ?><br />
		</td>
	</tr>
<?php
		$tableSnap=1;
		if($tableSnap==1){
?>
	<tr>
		<td align="" style="font-size:120%;">
			--- Tables --<br />
			<?php
				$tables = wp_uninstall_yuzu_shortcode_MySQLConnect($php_v,'tablelist');
				foreach($tables as $tbl){
					echo $tbl.'<br />';
				}
			?>
		</td>
	</tr>
<?php
		}
		$snap=0;
		if($snap==1){
?>
	<tr>
		<td align="" style="font-size:120%;">
			<?php
				echo '<pre>';
				var_dump($wpdb);
				echo '</pre>';
			?>
		</td>
	</tr>
<?php
		}
?>
<!-- Button -->
	<tr>
		<td>
			<p style="">
				--- アンストール --<br />
				以下のボタンをクリックすると確認なしにアンインストールを開始します。<br />
				バックアップは、取りましたか？<br />
				本当に削除してもいいか再度確認してから「アンインストール」してください。<br />
				<br />
				<input type="checkbox" name="alldel" id="alldel" value="checked"><b>ワードプレスの入っているフォルダーごと</b>削除する。<br />
				※フォルダーごと削除しない場合ワードプレスの入っているフォルダーは残して、そこにindex.htmlを作成します。<br />
				<br />
				<input type="submit" class="button-primary" name="action" value="アンインストール" />
				<input type="hidden" name="action" value="update" />
			</p>
		</td>
	</tr>
</form>
</table>

<?php
	}
}
/********************************************************/
function wp_uninstall_yuzu__save_info($dir)
/********************************************************/
{
	$file = $dir.'wp_uninstall_yuzu_info.php';
	
	$fp = fopen($file,'w');
	fwrite($fp, '<?php'."\n");
	
	//SITE INFO
	fwrite($fp, 'SITE_TITLE:'."\n");
	fwrite($fp, get_bloginfo( 'name' )."\n");
	fwrite($fp, '/END'."\n");

	fwrite($fp, 'SITE_DESCRIPTION:'."\n");
	fwrite($fp, get_bloginfo( 'description' )."\n");
	fwrite($fp, '/END'."\n");

	fwrite($fp, 'SITE_WPURL:'."\n");
	fwrite($fp, site_url()."\n");
	fwrite($fp, '/END'."\n");

	fwrite($fp, 'SITE_URL:'."\n");
	fwrite($fp, home_url()."\n");
	fwrite($fp, '/END'."\n");
	
	include_once( ABSPATH . 'wp-admin/includes/plugin.php' );
	$plugins = get_plugins();
	if (!empty($plugins)) {
		fwrite($fp, 'PLUGINS:'."\n");
		foreach ($plugins as $path => $plugin) {
			$rows = '';
			$rows .= $plugin['Name']."\t".$plugin['Version'];
			if (is_plugin_active( $path )) {
				$rows .= "\t".'有効'; 
			} else {
				$rows .= "\t".'無効'; 
			}
		    fwrite($fp,$rows."\n");
		}
		fwrite($fp, '/END'."\n");
	}
	fclose($fp);

	//
	// index.html
	//
	$indx = $dir.'index.html';
	$body =<<<EOM
<!DOCTYPE html>
<html lang="en">
<head>
	<meta name="viewport" content="width=device-width" />
	<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
	<title>WordPress &#8250; ReadMe</title>
</head>
<body>
<div style="text-align:center;">
This site is dormant<br />
このサイトは休眠中です。
</div>
</body>
</html>
EOM;
	$fp = fopen($indx,'w');
    fwrite($fp,$body);
	fclose($fp);
}
/********************************************************/
function wp_uninstall_yuzu_remove_directory($dir,$act=0,$topd=0) 
/********************************************************/
{
	$files = array_diff(scandir($dir), array('.','..'));
	foreach ($files as $file) {
		// ファイルかディレクトリによって処理を分ける
		if (is_dir("$dir/$file")) {
			// ディレクトリまるごと削除
			wp_uninstall_yuzu_remove_directory("$dir/$file",1,1);
		} else {
			$skip = 0;
			if($topd==0){
				if($file == 'index.html' || $file=='wp_uninstall_yuzu_info.php' ){
					$skip = 1;
				}
			}
			if($skip==0){
				unlink("$dir/$file");
			}
		}
	}
	// 指定したディレクトリを削除
	
	if($act==1){
	    return rmdir($dir);
	}
}
/********************************************************/
function wp_uninstall_yuzu_shortcode_MySQLConnect($php_v,$cmd)
/********************************************************/
{
	global $wpdb;
	$db_name = $wpdb->dbname;		//データベース名の取得
	$db_user = $wpdb->dbuser;		//データベース接続ユーザーの取得
	$db_pass = $wpdb->dbpassword;	//データベース接続用パスワードの取得
	$db_host = $wpdb->dbhost;		//データベースホストの取得
	$db_pfix = $wpdb->prefix;		//データベースホストの取得
	
	$link = mysqli_connect($db_host, $db_user, $db_pass,$db_name);
	if (!$link) {
		return('');
	}
	$stack = array();
	// データ処理
	if($cmd == 'tablelist' || $cmd == 'tabledelete'){
		$sql = "SHOW ";
		$sql.= "TABLES ";
		$sql.= ";";
		if( $result = mysqli_query($link, $sql) ){
			while ($row = $result->fetch_row()) {
				if(substr($row[0],0,strlen($db_pfix))==$db_pfix ){
					$stack[] = $row[0];
					if( $cmd == 'tabledelete' ){
						$sql = "DROP ";
						$sql.= "TABLE ";
						$sql.= $row[0];
						$sql.= ";";
						if( $resultA = mysqli_query($link, $sql) ){
							echo 'del query='.$sql.'<br />';
						}
					}
				}
			}
		}
	}
	mysqli_close($link);
	return($stack);
}
add_shortcode('call_MySQLConnect', 'shortcode_MySQLConnect');

/********************************************************/
function wp_uninstall_yuzu_cr($str,$cr)
/********************************************************/
{
	//
	// 改行の統一
	//
	$str = str_replace("\r\n", "#cr#" , $str);
	$str = str_replace("\n"  , "#cr#" , $str);
	$str = str_replace("\r"  , "#cr#" , $str);
	$str = str_replace("#cr#",  $cr   , $str);
	return $str;
}
/********************************************************/
function wp_uninstall_yuzu_metatext($val)
/********************************************************/
{
	$val = str_replace('<','&lt;'   ,$val);
	$val = str_replace('>','&gt;'   ,$val);
	$val = str_replace('\"','&quot;',$val);
	$val = str_replace("\'",'&#39;' ,$val);
	return $val;
}
/********************************************************/
function wp_uninstall_yuzu_plantext($val)
/********************************************************/
{
	$val = str_replace('&lt;'   , '<'  ,  $val);
	$val = str_replace('&gt;'   , '>'  ,  $val);
	$val = str_replace('&quot;' , '\"' ,  $val);
	$val = str_replace('&#39;'  , "\'" ,  $val);
	$val = str_replace('\"','"',$val);
	$val = str_replace("\'","'",$val);
	// &&?; で ? の表示
	$s=0;
	$p=strpos($val,'&&',$s);
	while( $p!==false ){
		$s = $p+2;
		if(substr($val,$p+3,1)==';'){
			$f = substr($val, 0,$p).substr($val,$p+2,1);
			$s = strlen($f);
			$b = substr($val,$p+4);
			$val = $f.$b;
		}
		$p=strpos($val,'&&',$s);
	}
	return $val;
}
?>
