<?php
/*
Plugin Name: ゆずまるの post memo
Description: 投稿ページのメモを記録
Version: 2.30311
Author: yuzumaru
*/
/********************************************************/
function postmemo_yuzu_ver()
/********************************************************/
{
	// ------------------------
	// [ version 表記 ]
	// ------------------------
	return "2.30311";
	return "2.21221";
	return "2.21220";
	return "2.20925";
	return "2.20204";
}
/********************************************************/
function postmemo_yuzu_snap($mess='',$fmod='a',$subname='SNAP')
/********************************************************/
{
	if($fmod=='a'){
		$file = plugin_dir_path(__FILE__).'postmemo_yuzu_'.$subname.'.txt';
		$postmemo_yuzu_ofp  = fopen($file,"a");
	}else{
		$file = plugin_dir_path(__FILE__).'postmemo_yuzu_'.$subname.'.txt';
		$postmemo_yuzu_ofp  = fopen($file,"w");
	}
	fprintf($postmemo_yuzu_ofp,"%s\n",$mess);
	fclose($postmemo_yuzu_ofp);
}
/********************************************************/
// 設定
/********************************************************/
add_action('save_post'     , 'postmemo_yuzu_save_post', 9999 );	// post save
add_action('add_meta_boxes', 'postmemo_yuzu' );					// add meta box
/********************************************************/
function postmemo_yuzu_save_post($post_id)
/********************************************************/
{
	$options = array();
	$options['postmemo_yuzu_memo_data'] = $_POST['postmemo_yuzu_memo_data'];
	delete_post_meta( $post_id, 'postmemo_yuzu');
	update_post_meta( $post_id, 'postmemo_yuzu', $options);
}
/********************************************************/
function postmemo_yuzu()
/********************************************************/
{
	add_meta_box( 'postmemo_yuzu_box', 'POST MEMO', 'postmemo_yuzu_sub', array('post','page'), 'side', 'high' ); // Add new metabox
}
/********************************************************/
function postmemo_yuzu_sub()
/********************************************************/
{
	global $post;
	
	$line_count = 0;
	
	$post_id = $post->ID;
	$memo_data_array = get_post_meta($post_id,'postmemo_yuzu');
	$memo_data       = $memo_data_array[0]['postmemo_yuzu_memo_data'];
	$setFlag=1;
	$postmemo_yuzu_ymemop = get_option('postmemo_yuzu_ymemop');
	if($postmemo_yuzu_ymemop!='' ){
		if(strpos($memo_data,$postmemo_yuzu_ymemop)!==false){
			$setFlag=0;
		}
	}
	$postmemo_yuzu_ymemoL = get_option('postmemo_yuzu_ymemoL');
	if($postmemo_yuzu_ymemoL==''){
		$postmemo_yuzu_ymemoL = 5;
	}
	$postmemo_yuzu_id       = get_option('postmemo_yuzu_id');
	$postmemo_yuzu_id_post  = get_option('postmemo_yuzu_id_post');
	$postmemo_yuzu_id_page  = get_option('postmemo_yuzu_id_page');
	
	$memo_data_cr    = postmemo_yuzu_cr($memo_data,"#cr#");
	$memo_data_stk   = explode("#cr#",$memo_data_cr);
	$memo_data_doc   = '';
	foreach($memo_data_stk as $line){
		$line = str_replace("<", "&lt;"  , $line);
		$line = str_replace(">", "&gt;"  , $line);
		$line = str_replace('"', "&quot;", $line);
		if(substr($line,0,7)=='http://'||substr($line,0,8)=='https://'){
			if(substr($line,0,7)=='http://'){
				$l = 7;
			}else{
				$l = 8;
			}
			$p = strpos($line,' ');
			if($p!==false){
				$str = substr($line,$p+1);
				$url = substr($line,0,$p);
				$line = '<a href="'.$url.'" target="_blank">'.$str.'</a>';
			}else{
				$str = substr($line,0,40);
				$url = $line;
				$line = '<a href="'.$url.'" target="_blank">'.$str.'</a>';
			}
		}
		$memo_data_doc.=$line.'<br />';
		//postmemo_yuzu_snap('setFlag='.$setFlag.' line_count='.$line_count.'/'.$postmemo_yuzu_ymemoL.' line='.$line);
		if($line_count<$postmemo_yuzu_ymemoL){
			if($line!=''){
				if( strpos($line,$postmemo_yuzu_ymemop)!==false && $setFlag==0){
					$setFlag=1;
				}
				if($setFlag==1){
					$memo_data_easydoc.=$line.'<br />';
					$line_count++;
				}
			}
		}
	}
?>
<div style="text-align:right;">
	<?php
		$posttype = get_post_type( get_the_ID() );
		if( $postmemo_yuzu_id!='' ){
			if( $postmemo_yuzu_id_post!='' && $posttype=='post'||$postmemo_yuzu_id_page!='' && $posttype=='page'){
				echo 'post id='.get_the_ID().' ';
			}
		}
		echo '<b>ver.'.postmemo_yuzu_ver().'</b>';
	?>
	<input type="button" id="postmemo_yuzu_bviw" value="full" OnClick="postmemo_yuzu_post_oc('easyfull');">
	<input type="button" id="postmemo_yuzu_botn" value="edit" OnClick="postmemo_yuzu_post_oc('');">
</div>
<div id="postmemo_yuzu_post_edit" style="display:none;">
<textarea name="postmemo_yuzu_memo_data" style="width:100%;"><?php echo $memo_data; ?></textarea>
<div style="font-size:10px;text-align:right;"><?php echo '※メモを書き込む場合は「更新」してください'; ?></div>
</div>
<div id="postmemo_yuzu_post_view" style="word-wrap: break-word;">
	<?php echo $memo_data_easydoc; ?>
</div>
<div id="postmemo_yuzu_post_full" style="word-wrap: break-word;display:none">
	<?php echo $memo_data_doc; ?>
</div>
<script>
function postmemo_yuzu_post_oc(vtype)
{
	var post_edit_element = document.getElementById('postmemo_yuzu_post_edit');
	var post_botn_element = document.getElementById('postmemo_yuzu_botn');
	var post_bviw_element = document.getElementById('postmemo_yuzu_bviw');
	var post_view_element = document.getElementById('postmemo_yuzu_post_view');
	var post_full_element = document.getElementById('postmemo_yuzu_post_full');
	if(vtype==''){
		if(post_edit_element.style.display=='' ){
			post_edit_element.style.display='none';
			post_view_element.style.display='';
			post_full_element.style.display='none';
			post_bviw_element.style.display='';
			post_bviw_element.value = "full";
			post_botn_element.value = "edit";
		}else{
			post_edit_element.style.display='';
			post_view_element.style.display='none';
			post_full_element.style.display='none';
			post_bviw_element.style.display='none';
			post_botn_element.value = "view";
		}
	}else if(vtype=='easyfull'){
		if(post_view_element.style.display=='' ){
			post_view_element.style.display='none';
			post_full_element.style.display='';
			post_bviw_element.value = "easy";
		}else{
			post_view_element.style.display='';
			post_full_element.style.display='none';
			post_bviw_element.value = "full";
		}
	}
}
</script>
<?php
}
/********************************************************/
function postmemo_yuzu_subStr($StrMax=30,$postid='',$topp='')
/********************************************************/
{
	global $post;

	$line_count = 0;

	$post_id = $post->ID;
	if($postid!=''){
		$post_id = $postid;
	}
	$memo_data_array = get_post_meta($post_id,'postmemo_yuzu');
	$memo_data       = $memo_data_array[0]['postmemo_yuzu_memo_data'];
	if($topp!=''){
		$p = strpos($memo_data,$topp);
		if($p!==false){
			$memo_data = substr($memo_data,$p+strlen($topp));
		}
	}
	$memo_data_cr    = postmemo_yuzu_cr($memo_data,"#cr#");
	$memo_data_stk   = explode("#cr#",$memo_data_cr);
	$memo_data_doc   = '';
	foreach($memo_data_stk as $line){
		$line = str_replace("<", "&lt;"  , $line);
		$line = str_replace(">", "&gt;"  , $line);
		$line = str_replace('"', "&quot;", $line);
		$memo_data_doc.=$line.'<br />';
		if($line!=''){
			$l=strlen($line);
			for($i=0;$i<$l;$i++){
				if(strlen($memo_data_easydoc)<$StrMax){
					$memo_data_easydoc.=substr($line,$i,1);
				}else{
					return($memo_data_easydoc);
				}
			}
		}
	}
	return($memo_data_easydoc);
}
/********************************************************/
add_filter( 'manage_posts_columns', 'postmemo_yuzu_add_columns' ,10);	//投稿ページ
function postmemo_yuzu_add_columns($columns)
/********************************************************/
{
    if(get_option('postmemo_yuzu_id')    !='' && get_option('postmemo_yuzu_id'    .'_post')!=''){ $columns['yid']    = 'ID'; }
    if(get_option('postmemo_yuzu_ymemo') !='' && get_option('postmemo_yuzu_ymemo' .'_post')!=''){ $columns['ymemo']  = 'メモ'; }
    if(get_option('postmemo_yuzu_ycount')!='' && get_option('postmemo_yuzu_ycount'.'_post')!=''){ $columns['ycount'] = '字数'; }
    return $columns;
}
/********************************************************/
add_filter( 'manage_pages_columns', 'postmemo_yuzu_add_columns_page' ,10);	//固定ページ
function postmemo_yuzu_add_columns_page($columns)
/********************************************************/
{
    if(get_option('postmemo_yuzu_id')    !='' && get_option('postmemo_yuzu_id'    .'_page')!=''){ $columns['yid']    = 'ID'; }
    if(get_option('postmemo_yuzu_ymemo') !='' && get_option('postmemo_yuzu_ymemo' .'_page')!=''){ $columns['ymemo']  = 'メモ'; }
    if(get_option('postmemo_yuzu_ycount')!='' && get_option('postmemo_yuzu_ycount'.'_page')!=''){ $columns['ycount'] = '字数'; }
    return $columns;
}
/********************************************************/
add_action( 'manage_posts_custom_column', 'postmemo_yuzu_add_columns_row', 10, 2 );
add_action( 'manage_pages_custom_column', 'postmemo_yuzu_add_columns_row', 10, 2 );
function postmemo_yuzu_add_columns_row($column_name, $post_id)
/********************************************************/
{
    if ( 'yid' == $column_name ) {
		echo $post_id;
    }else if ( 'ymemo' == $column_name ) {
		$postmemo_yuzu_ymemos = get_option('postmemo_yuzu_ymemos');
		if($postmemo_yuzu_ymemos==''){
			$postmemo_yuzu_ymemos = 3;
		}
		$postmemo_yuzu_ymemop = get_option('postmemo_yuzu_ymemop');
        echo postmemo_yuzu_subStr($postmemo_yuzu_ymemos,$post_id,$postmemo_yuzu_ymemop,"return");
		
    } elseif ( 'ycount' == $column_name ) {
        $count = mb_strlen(strip_tags(get_post_field('post_content', $post_id)));
        echo $count;
		
    }
}
/********************************************************/
add_action('admin_menu', 'postmemo_yuzu_control');			// WP設定画面に追加
function postmemo_yuzu_control()		// WP設定画面に追加
/********************************************************/
{
	add_options_page(
		'postmemo_yuzu'					,	// 1.設定画面での見出し
		'postmemo_yuzu'					,	// 2.設定->メニューでの名前
		'administrator'					,	// 3.アクセスレベル
		__FILE__						,	// 4.決まり文句
		'postmemo_yuzu_control_entry'		// 5.設定の本体関数名
	);
}
/********************************************************/
function postmemo_yuzu_control_entry()
/********************************************************/
{
	echo "<h2>ゆずまるの postmemo_yuzu ver ".postmemo_yuzu_ver().".</h2>";
	//----------------------------------------------------
	// 保存
	//----------------------------------------------------
	if( isset($_POST['action']) ){
		update_option('postmemo_yuzu_id'          , $_POST['postmemo_yuzu_id']);
		update_option('postmemo_yuzu_id_post'     , $_POST['postmemo_yuzu_id_post']);
		update_option('postmemo_yuzu_id_page'     , $_POST['postmemo_yuzu_id_page']);

		update_option('postmemo_yuzu_ymemo'       , $_POST['postmemo_yuzu_ymemo']);
		update_option('postmemo_yuzu_ymemos'      , $_POST['postmemo_yuzu_ymemos']);
		update_option('postmemo_yuzu_ymemoL'      , $_POST['postmemo_yuzu_ymemoL']);
		update_option('postmemo_yuzu_ymemop'      , $_POST['postmemo_yuzu_ymemop']);
		update_option('postmemo_yuzu_ymemo_post'  , $_POST['postmemo_yuzu_ymemo_post']);
		update_option('postmemo_yuzu_ymemo_page'  , $_POST['postmemo_yuzu_ymemo_page']);


		update_option('postmemo_yuzu_ycount'      , $_POST['postmemo_yuzu_ycount']);
		update_option('postmemo_yuzu_ycount_post' , $_POST['postmemo_yuzu_ycount_post']);
		update_option('postmemo_yuzu_ycount_page' , $_POST['postmemo_yuzu_ycount_page']);

	}
	//----------------------------------------------------
	// 読み込み
	//----------------------------------------------------
	$postmemo_yuzu_id  = get_option('postmemo_yuzu_id');
	$postmemo_yuzu_id_post  = get_option('postmemo_yuzu_id_post');
	$postmemo_yuzu_id_page  = get_option('postmemo_yuzu_id_page');
	
	$postmemo_yuzu_ymemo  = get_option('postmemo_yuzu_ymemo');
	$postmemo_yuzu_ymemos = get_option('postmemo_yuzu_ymemos');
	if($postmemo_yuzu_ymemos==''){$postmemo_yuzu_ymemos = 30;}
	$postmemo_yuzu_ymemoL = get_option('postmemo_yuzu_ymemoL');
	if($postmemo_yuzu_ymemoL==''){$postmemo_yuzu_ymemoL = 5;}
	$postmemo_yuzu_ymemop = get_option('postmemo_yuzu_ymemop');
	$postmemo_yuzu_ymemo_post  = get_option('postmemo_yuzu_ymemo_post');
	$postmemo_yuzu_ymemo_page  = get_option('postmemo_yuzu_ymemo_page');
	
	$postmemo_yuzu_ycount = get_option('postmemo_yuzu_ycount');
	$postmemo_yuzu_ycount_post  = get_option('postmemo_yuzu_ycount_post');
	$postmemo_yuzu_ycount_page  = get_option('postmemo_yuzu_ycount_page');
	//------------------------------------------------------------------------------------
	// 表示
	//------------------------------------------------------------------------------------
?>
	<form method="post" action="">
	<table>
		<tr>
			<td valign="top" colsapn="2">
				<div style="border:#ccc solid 1px;padding:0.5rem;margin:0.5rem 0;background-color:#f6f6f6;">
					<b>一覧表示項目</b>
				</div>
			</td>
		</tr>
		<tr>
			<td valign="top">
				<table class="tbl">
					<tr>
						<th>表示</th>
						<th>投稿ページ一覧</th>
						<th>固定ページ一覧</th>
					</tr>
					<tr>
						<td>
							<input type="checkbox" name="postmemo_yuzu_id" value="checked" <?php echo $postmemo_yuzu_id; ?>>ID
						</td>
						<td style="text-align:center;">
							<input type="checkbox" name="postmemo_yuzu_id_post" value="checked"<?php echo $postmemo_yuzu_id_post; ?>>
						</td>
						<td style="text-align:center;">
							<input type="checkbox" name="postmemo_yuzu_id_page" value="checked"<?php echo $postmemo_yuzu_id_page; ?>>
						</td>
					</tr>
					<tr>
						<td>
							<input type="checkbox" name="postmemo_yuzu_ymemo"  value="checked" <?php echo $postmemo_yuzu_ymemo; ?>>メモ
								( 一覧表示文字数<input type="text" name="postmemo_yuzu_ymemos"  value="<?php echo $postmemo_yuzu_ymemos; ?>" style="width:3rem;"> )
								抜出開始先頭文字列<input type="text" name="postmemo_yuzu_ymemop"  value="<?php echo $postmemo_yuzu_ymemop; ?>" style="width:10rem;">
								表示行数<input type="text" name="postmemo_yuzu_ymemoL"  value="<?php echo $postmemo_yuzu_ymemoL; ?>" style="width:3rem;">
						</td>
						<td style="text-align:center;">
							<input type="checkbox" name="postmemo_yuzu_ymemo_post" value="checked"<?php echo $postmemo_yuzu_ymemo_post; ?>>
						</td>
						<td style="text-align:center;">
							<input type="checkbox" name="postmemo_yuzu_ymemo_page" value="checked"<?php echo $postmemo_yuzu_ymemo_page; ?>>
						</td>
					</tr>
					<tr>
						<td>
							<input type="checkbox" name="postmemo_yuzu_ycount" value="checked" <?php echo $postmemo_yuzu_ycount; ?>>字数(未使用)
						</td>
						<td style="text-align:center;">
							<input type="checkbox" name="postmemo_yuzu_ycount_post" value="checked"<?php echo $postmemo_yuzu_ycount_post; ?>>
						</td>
						<td style="text-align:center;">
							<input type="checkbox" name="postmemo_yuzu_ycount_page" value="checked"<?php echo $postmemo_yuzu_ycount_page; ?>>
						</td>
					</tr>
				</table>
				<style>
					table.tbl th ,table.tbl td{
						border:1px solid #ccc;
						padding:0.5rem;
					}
					table.tbl tr:first-child{
						background:#666;
						color:#fff;
					}
				</style>
			</td>
		</tr>
		<tr>
			<td colsapn="2">
				<input type="submit" class="button-primary" style="margin-right:0.5rem;" name="action" value="<?php _e('Save Changes') ?>" OnClick="comand.value='itempage';"/>
			<td>
		</tr>
	</table>
	<input type="hidden" name="action" value="update" />
	<input type="hidden" name="comand" value="" />
	</form>
<?php
}
/********************************************************/
function postmemo_yuzu_cr($str,$cr)
/********************************************************/
{
	$str = str_replace("\r\n", "#cr#" , $str);
	$str = str_replace("\n"  , "#cr#" , $str);
	$str = str_replace("\r"  , "#cr#" , $str);
	$str = str_replace("#cr#",  $cr   , $str);
	return $str;
}

?>
