<?php
/*
Plugin Name: ゆずまるの Address Auto Input
Description: form の 郵便番号 から 住所を自動入力する
Version: 2.01013
Author: yuzumaru
*/
/*******************************************************************************/
function adrs_autoinput_yuzu_ver()
/*******************************************************************************/
{
	// ------------------------
	// [ version 表記 ]
	// ------------------------
	return "2.10918";
}
/*******************************************************************************/
// Style Sheet / JavaScript 読み込み
/*******************************************************************************/
function adrs_autoinput_yuzu_read_stylesheets() {
	// --- style sheet
	$styleSheet = WP_PLUGIN_URL.'/adrs_autoinput_yuzu/css/adrs_autoinput_yuzu_'.'button'.'.css';
	//wp_enqueue_style( 'adrs_autoinput_yuzu-style' , $styleSheet  );
	
	// --- javascript
	$javaScript =  plugins_url( '/js/adrs_autoinput_yuzu_'.'jsunit'.'.js', __FILE__ );
	wp_enqueue_script( 'adrs_autoinput_yuzu-style' , $javaScript , array('jquery') , date('U') );

	$javaScript =  'https://ajaxzip3.github.io/ajaxzip3.js';
	wp_enqueue_script( 'adrs_autoinput_yuzu-ajaxzip' , $javaScript , array('jquery') , date('U') );
}
//------------------------------------------------------------------------------
if(get_option('adrs_autoinput_yuzu_'.'ACTIVE')!==''){
	//--------------------------------------------------------------------------
	// page で使う javascript 読み込み
	//--------------------------------------------------------------------------
	add_action( 'wp_enqueue_scripts', 'adrs_autoinput_yuzu_read_stylesheets' );
	//--------------------------------------------------------------------------
	// 管理画面で使う javascript 読み込み
	//--------------------------------------------------------------------------
	add_action( 'admin_enqueue_scripts', function() {
	    wp_enqueue_script(
			'adrs_autoinput_yuzu-style',
	        plugins_url( '/js/adrs_autoinput_yuzu_'.'jsunit'.'.js', __FILE__ ),
	        [ 'jquery' ]
		);
	});
}
/*******************************************************************************/
// 追加コンテンツ
/*******************************************************************************/
function adrs_autoinput_yuzu_get_myform(){
	$line  = "\n";
	$line .= '<form>';
	$line .= '<input type="hidden" name="yuzu_adrs_autoinput_yuzu_ZipTemp" id="yuzu_adrs_autoinput_yuzu_ZipTemp">';
	$line .= '<div id="yuzu_adrs_autoinput_yuzu_area"></div>';
	$line .= '</form>'."\n";
	return($line);
}
/*******************************************************************************/
// コンテンツの下に付け加えるテキスト
/*******************************************************************************/
function adrs_autoinput_yuzu_add_content_after($content) {
	if( preg_match('/\<form/i', $content) ){
	    $content .= adrs_autoinput_yuzu_get_myform();
	}
	return $content;
}
//--- ↑↑↑↑↑ ---------------------------------------------------------------
if(get_option('adrs_autoinput_yuzu_'.'ACTIVE')!==''){
	add_filter('the_content', 'adrs_autoinput_yuzu_add_content_after' ,999);
}
/*******************************************************************************/
// ショートコード
/*******************************************************************************/
function adrs_autoinput_yuzu_shortcode(){
	return(adrs_autoinput_yuzu_get_myform());
}
//--- ↑↑↑↑↑ ---------------------------------------------------------------
add_shortcode('AddressAutoInput_yuzu','adrs_autoinput_yuzu_shortcode');
/*******************************************************************************/
// モジュールの読み込み
/*******************************************************************************/
$require_file = plugin_dir_path(__FILE__).'adrs_autoinput_yuzu_home.php';
require($require_file);
//==============================================================================
// ダッシュボードメニュー 表示(グループ)
//==============================================================================
function adrs_autoinput_yuzu_admin_menu()
{
	$menu_id = 
		add_menu_page(
			'Address Auto Input',		// ページタイトル (ブラウザのページタイトルに表示される)
			'Address Auto Input',		// メニュータイトル
			'manage_options',			// 権限
			'ADRSAUTOIP_adminmenu',		// メニュースラッグ
			'adrs_autoinput_yuzu_home',	// 呼び出し関数
			//'dashicons-performance',	// アイコンURL (dashicons)https://elearn.jp/wpman/column/c20170626_01.html
			'dashicons-cart',			// アイコンURL (Awesome) urlの場合 ↑
			'3.0011170'					// 表示位置 (通常50ぐらい。表示状況を見ながら調整)
		);
    if( $menu_id !== false ){
		add_submenu_page(
			'WelcartPE_adminmenu',		// 親メニュースラッグ
			'Home',						// サブメニューページのタイトル(ブラウザページタイトルに表示される)
			'Home',						// メニュータイトル
			'manage_options',			// 権限
			'ADRSAUTOIP_HOME',			// サブメニューのスラッグ
			'adrs_autoinput_yuzu_home'	// 呼び出し関数
		);
	}
}
//--- ↑↑↑↑↑ ---------------------------------------------------------------
//add_action('admin_menu', 'adrs_autoinput_yuzu_admin_menu');
//==============================================================================
// ダッシュボードメニュー 設定 -> adrs_autoinput_yuzu
//==============================================================================
/*******************************************************************************/
function adrs_autoinput_yuzu_control()						// WP設定画面に追加
/*******************************************************************************/
{
	add_options_page(
		'ゆずまるのAddressAutoInput'	,	// 1.設定画面での見出し
		'ゆずまるのAddressAutoInput'	,	// 2.設定->メニューでの名前
		'administrator'					,	// 3.アクセスレベル
		__FILE__						,	// 4.決まり文句
		'adrs_autoinput_yuzu_home'			// 5.設定の本体関数名
	);
}
//--- ↑↑↑↑↑ ---------------------------------------------------------------
add_action('admin_menu', 'adrs_autoinput_yuzu_control');	// WP設定画面に追加
/*******************************************************************************/
function adrs_autoinput_yuzu_cr($str,$cr)
/*******************************************************************************/
{
	$str = str_replace("\r\n", "#cr#" , $str);
	$str = str_replace("\n"  , "#cr#" , $str);
	$str = str_replace("\r"  , "#cr#" , $str);
	$str = str_replace("#cr#",  $cr   , $str);
	return $str;
}
/*******************************************************************************/
function adrs_autoinput_yuzu_metatext($val)
/*******************************************************************************/
{
	$val = str_replace('<','&lt;'   ,$val);
	$val = str_replace('>','&gt;'   ,$val);
	$val = str_replace('\"','&quot;',$val);
	$val = str_replace("\'",'&#39;' ,$val);
	return $val;
}
/*******************************************************************************/
function adrs_autoinput_yuzu_plantext($val)
/*******************************************************************************/
{
	$val = str_replace('&lt;'   , '<'  ,  $val);
	$val = str_replace('&gt;'   , '>'  ,  $val);
	$val = str_replace('&quot;' , '\"' ,  $val);
	$val = str_replace('&#39;'  , "\'" ,  $val);
	$val = str_replace('\"','"',$val);
	$val = str_replace("\'","'",$val);
	return $val;
}
/*******************************************************************************/
?>
